/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.tile;

import gloridifice.watersource.client.render.tile.AnimationTile;
import gloridifice.watersource.registry.TileEntityTypesRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class WaterDispenserDownTile
extends AnimationTile {
    LazyOptional<FluidTank> tank = LazyOptional.of(this::createFluidHandler);
    public int capacity;
    int heightAmount;

    public WaterDispenserDownTile(int capacity) {
        super(TileEntityTypesRegistry.WATER_DISPENSER_DOWN);
        this.capacity = capacity;
    }

    public LazyOptional<FluidTank> getTank() {
        return this.tank;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tank.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbtTag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.tank.ifPresent(fluidTank -> fluidTank.readFromNBT(compoundNBT.func_74775_l("tank")));
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        this.tank.ifPresent(fluidTank -> compoundNBT.func_218657_a("tank", (INBT)fluidTank.writeToNBT(new CompoundNBT())));
        return super.func_189515_b(compoundNBT);
    }

    private FluidTank createFluidHandler() {
        return new FluidTank(this.capacity){

            protected void onContentsChanged() {
                WaterDispenserDownTile.this.refresh();
                WaterDispenserDownTile.this.func_70296_d();
                super.onContentsChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                return !stack.getFluid().getAttributes().isLighterThanAir() && stack.getFluid().getAttributes().getTemperature() < 500;
            }
        };
    }

    public int getFluidAmount() {
        return ((FluidTank)this.tank.orElse(null)).getFluidAmount();
    }

    private void updateHeight() {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            if (this.heightAmount > this.getFluidAmount()) {
                this.heightAmount -= Math.max(1, (this.heightAmount - this.getFluidAmount()) / 10);
            } else if (this.heightAmount < this.getFluidAmount()) {
                this.heightAmount += Math.max(1, (this.getFluidAmount() - this.heightAmount) / 10);
            }
        }
    }

    public float getHeight() {
        this.updateHeight();
        return 0.75f * (float)this.heightAmount / (float)this.capacity;
    }
}

